<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

abstract class XenCentral_AdServer_Helper_Attributes_Abstract extends XenCentral_AdServer_Helper_StatsInPercentage
{
    protected abstract function _getColumn();

    public function getValueFromData($data)
    {
        return $data['count'];
    }

    public function getLabelFromData($data)
    {
        return $data[$this->_getColumn()];
    }

    /**
     * @param $data
     * @return mixed
     * Allows attribute types to update data, like converting ip to country name, re-order data etc.
     */
    public function parseData($data)
    {
        return $data;
    }

    public function getQuery()
    {
        return "
            SELECT {$this->_getColumn()}, count(*) AS count
            FROM xcas_clicks_{$this->content_type}
            WHERE dateline>={$this->from}
            AND dateline<={$this->to}
            AND {$this->content_type}Id IN(" . implode(',', $this->content_ids) . ")
            GROUP BY {$this->_getColumn()}
            ".($this->_needsSqlOrdering()?'ORDER BY count DESC':'')."
        ";
    }

    /**
     * @return bool
     * Child classes may return false to avoid unneeded SQL ordering
     */
    protected function _needsSqlOrdering()
    {
        return true;
    }

    /**
     * @param $model
     * @return XenForo_Model
     */
    protected function _getModelFromCache($model)
    {
        static $cache;

        if(isset($cache[$model])) {
            return $cache[$model];
        }

        $cache[$model]=XenForo_Model::create($model);

        return $cache[$model];
    }
}